"use client"

import { Loader, Check, X, } from "lucide-react";
import { Button } from "@/components/ui/button";
import { useApplicationWorkflow } from "@/hooks/use-application-workflow";
import { useStatusLoadingContentForAgency, UseStatusLoadingContentForAgencyProps } from "../hook/use-status-loading-content";
import { useMemo } from "react";

export function StatusRevalidateBannerModalSidebar({ agency }: { agency: string }) {
  const content = useMemo(() => {
    return {
      agency: agency,
      loading: <INTERNAL__Loading />,
      success: {
        content: <INTERNAL__Success />,
        timeout: 150000,
      },
      error: <INTERNAL__Error />,
    } satisfies UseStatusLoadingContentForAgencyProps
  }, [agency])

  const {
    isLoading,
    data: showing
  } = useStatusLoadingContentForAgency(content)

  const { setWorkflow, workflow } = useApplicationWorkflow()

  if (isLoading || !showing) {
    return
  }

  return (
    <Button
      variant={"ghost"}
      size="sm"
      className="w-full h-fit justify-start animate-in fade-in"
      onClick={() => {
        if (!workflow || !("id" in workflow)) {
          return;
        }

        setWorkflow({
          __tag: "STATUS_AGENCY_FEED",
          id: workflow.id
        })
      }}
    >
      <div className="py-4 flex items-center gap-2 justify-start">
        {showing}
      </div>
    </Button>
  )
}

function INTERNAL__Loading() {
  return (
    <>
      <div
        className="flex size-6 shrink-0 items-center justify-center rounded-full border border-border animate-pulse"
        aria-hidden="true"
      >
        <Loader className="opacity-60 animate-spin size-3 stroke-2" />
      </div>
      <div className="flex grow items-center gap-12 animate-pulse">
        <div className="space-y-1">
          <p className="text-sm font-medium">Build in progress</p>
        </div>
      </div>
    </>
  )
}

function INTERNAL__Success() {
  return (
    <>
      <div
        className="flex size-6 shrink-0 items-center justify-center rounded-full border border-border"
        aria-hidden="true"
      >
        <Check className="opacity-60 size-3 stroke-2 text-green-500 dark:text-green-600" />
      </div>
      <div className="flex grow items-center gap-12">
        <div className="space-y-1">
          <p className="text-sm font-medium">Built successfully!</p>
        </div>
      </div>
    </>
  )
}

function INTERNAL__Error() {
  return (
    <>
      <div
        className="flex size-6 shrink-0 items-center justify-center rounded-full border border-border"
        aria-hidden="true"
      >
        <X className="opacity-60 size-3 stroke-2 text-destructive" />
      </div>
      <div className="flex grow items-center gap-12 text-pretty">
        <p className="text-sm font-medium">Error during build.</p>
      </div>
    </>
  )
}
